/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.lspeed;

import ibm.nways.jdm.CompoundStatus;
import ibm.nways.jdm.GraphicActionNavigate;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicFlyOver;
import ibm.nways.jdm.GraphicHelp;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.GraphicPanelProducer;
import ibm.nways.jdm.HelpRef;
import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.I18NStringTranslated;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.Log;
import ibm.nways.jdm.NavInitialRow;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.RemoteStatus;
import ibm.nways.jdm.Status;
import ibm.nways.jdm.StatusProxy;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.eui.MultiLineLabel;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.lspeed.LsBoxInfo;
import ibm.nways.lspeed.LsPortCompStatusMgr;
import java.awt.Font;
import java.awt.Image;
import java.awt.Label;
import java.awt.Point;
import java.io.Serializable;
import java.util.ResourceBundle;

public class LsModuleView
implements GraphicPanelProducer {
    private static ResourceBundle lspeedBundle;
    private LsBoxInfo boxInfo;
    private JdmBrowser lsBrowser;
    private boolean isApplication;
    private boolean loggingOn;
    private int moduleType;
    private Integer Slot;
    private GenModel lsModule_model;
    private GenModel lsAtmModule_model;
    private GenModel lsPort_model;
    private GenModel lsPortStatus2_model;
    private GenModel lsPortMau_model;
    private GenModel lsOC3StatusPort_model;
    private GenModel lsModuleConfig_model;
    private GraphicPanel graphicPanel;
    private GraphicContainer grContainer;
    private boolean SavePanel;
    public static final Point helpPt;
    public static final Point mezz1Location;
    public static final Point mezz2Location;
    public static final int firstMezz = 1;
    public static final int secondMezz = 2;
    public static final int lanMezz = 3;

    public LsModuleView(Integer n) {
        this.Slot = n;
        lspeedBundle = ResourceBundle.getBundle("ibm.nways.lspeed.LsGeneralResources");
    }

    public GraphicPanel getGraphicFor(NavigationDestination navigationDestination, GraphicPanel graphicPanel, NavigationContext navigationContext) {
        return this.getGraphicFor(navigationDestination, graphicPanel, navigationContext, true);
    }

    public GraphicPanel getGraphicFor(NavigationDestination navigationDestination, GraphicPanel graphicPanel, NavigationContext navigationContext, boolean bl) {
        ModelInfo modelInfo;
        boolean bl2;
        int n;
        block39: {
            Object v;
            n = 0;
            this.boxInfo = LsBoxInfo.getFromNavContext(navigationContext, true);
            this.lsBrowser = this.boxInfo.getLsBrowser();
            this.isApplication = this.lsBrowser.getIsApplication();
            if (this.isApplication) {
                this.loggingOn = Log.getLog().getLoggingState();
            }
            if ((v = this.boxInfo.getLsModuleList().get(this.Slot)) == null) {
                bl2 = true;
                if (this.loggingOn) {
                    System.out.println("LS:ModuleView - module not in slot originally");
                }
            } else {
                this.moduleType = (Integer)v;
                modelInfo = new ModelInfo();
                modelInfo.add("Index.Slot", this.Slot);
                modelInfo.add("Index.SubSlot", new Integer(1));
                try {
                    ModelInfo modelInfo2 = this.boxInfo.getLsModel("LsModuleConfig").getInfo("ConfigData", "default", modelInfo);
                    if (modelInfo2 == null) {
                        bl2 = true;
                        if (this.loggingOn) {
                            System.out.println("LS:ModuleView - module no longer in slot");
                        }
                    } else if (modelInfo2.timeoutDetected) {
                        bl2 = false;
                        if (this.moduleType == 21) {
                            n = this.boxInfo.getNumOfLecPorts(this.Slot);
                        }
                    } else if (this.moduleType == LsBoxInfo.determineModuleType(modelInfo2.get("ConfigData.ModType"), modelInfo2.get("ConfigData.Mezz1Status"), modelInfo2.get("ConfigData.Mezz2Status"))) {
                        bl2 = false;
                        Serializable serializable = modelInfo2.get("ConfigData.ModNumBridgePorts");
                        n = serializable instanceof Integer ? (Integer)serializable : 0;
                    } else {
                        bl2 = true;
                        if (this.loggingOn) {
                            System.out.println("LS:ModuleView - different type of module in slot");
                        }
                    }
                }
                catch (Exception exception) {
                    bl2 = true;
                    if (!this.loggingOn) break block39;
                    System.out.println("LS:Failed to get LsModuleConfigInfo");
                    exception.printStackTrace();
                }
            }
        }
        if (bl2) {
            return this.ConfigChangeWarningPanel(this.Slot);
        }
        modelInfo = this.boxInfo.getModuleGraphicList().get(this.Slot);
        if (modelInfo != null) {
            if (this.moduleType == 21 && n != this.boxInfo.getNumOfLecPorts(this.Slot)) {
                this.boxInfo.updateAtmLecPorts(this.Slot, new Integer(n));
                this.boxInfo.deleteModuleGraphic(this.Slot);
            } else {
                return (GraphicPanel)((Object)modelInfo);
            }
        }
        if (bl) {
            this.lsBrowser.displayMsg(lspeedBundle.getString("StartModuleGraphic"));
        }
        this.SavePanel = true;
        this.lsBrowser = this.boxInfo.getLsBrowser();
        this.lsPort_model = this.boxInfo.getLsModel("LsPort");
        this.lsPortStatus2_model = this.boxInfo.getLsModel("LsPortStatus2");
        this.lsModule_model = this.boxInfo.getLsModel("LsModule");
        this.lsAtmModule_model = this.boxInfo.getLsModel("LsAtmModule");
        if (this.loggingOn) {
            System.out.println("LS:LsModuleView building graphic for Module " + this.Slot.toString());
        }
        this.grContainer = new GraphicContainer();
        this.setModuleBackground();
        if (this.moduleType > 0 && this.moduleType < 11) {
            this.moduleType += 10;
        }
        if (this.loggingOn) {
            System.out.println("LS: moduleType for graphic is " + this.moduleType);
        }
        switch (this.moduleType) {
            case 11: {
                this.build10BaseT(1);
                break;
            }
            case 12: {
                this.build10BaseT(1);
                this.build10BaseT(2);
                break;
            }
            case 13: {
                this.build10BaseT(1);
                this.buildFDDI(2, 13);
                break;
            }
            case 14: {
                this.build10BaseT(1);
                this.build10BaseT(3);
                this.buildLan();
                break;
            }
            case 15: {
                this.build10BaseF(1);
                break;
            }
            case 16: {
                this.build10BaseF(1);
                this.buildFDDI(2, 10);
                break;
            }
            case 17: {
                this.build10BaseF(1);
                this.build10BaseF(2);
                break;
            }
            case 18: {
                this.buildFDDI(1, 1);
                break;
            }
            case 19: {
                this.buildBaseTX();
                break;
            }
            case 20: {
                this.buildBaseFX();
                break;
            }
            case 21: {
                this.SavePanel = this.buildAtm();
                break;
            }
            case 22: {
                this.buildTelco();
                break;
            }
            default: {
                if (!this.loggingOn) break;
                System.out.println("LS: unknown module type for graphics");
            }
        }
        this.graphicPanel = new GraphicPanel(this.lsBrowser, this.grContainer);
        if (this.SavePanel) {
            this.boxInfo.addModuleGraphic(this.Slot, this.graphicPanel);
        }
        if (bl) {
            this.lsBrowser.displayMsg(lspeedBundle.getString("EndModuleGraphic"));
        }
        return this.graphicPanel;
    }

    private void setModuleBackground() {
        int n = 0;
        int n2 = 20;
        int n3 = 40;
        GraphicHelp graphicHelp = new GraphicHelp(this.lsBrowser, helpPt, new HelpRef(this));
        this.grContainer.add(graphicHelp);
        Label label = new Label("Module " + this.Slot.toString() + ": ", 1);
        label.setLocation(new Point(n, n2));
        this.grContainer.add(label);
        Label label2 = new Label(LsBoxInfo.ModuleDescr[this.moduleType]);
        label2.setLocation(new Point(n, n3));
        this.grContainer.add(label2);
        ModelInfo modelInfo = new ModelInfo();
        modelInfo.add("Index.Slot", this.Slot);
        modelInfo.add("Index.SubSlot", new Integer(1));
        NavigationDestination navigationDestination = this.moduleType == 21 ? new NavigationDestination("ibm.nways.lspeed.LsAtmModulePanel", this.lsAtmModule_model) : new NavigationDestination("ibm.nways.lspeed.LsModulePanel", this.lsModule_model);
        navigationDestination.setGraphicPanelProducer(this);
        NavigationContext navigationContext = new NavigationContext();
        NavInitialRow.setInitialRow(navigationContext, modelInfo);
        navigationContext.setParent(this.lsBrowser.getNavigationTree().getNavContext());
        GraphicImage graphicImage = new GraphicImage(this.lsBrowser.imageFrom(this, LsBoxInfo.ModPicGifs[this.moduleType]), mezz1Location, 4, new GraphicActionNavigate(this.lsBrowser, navigationDestination, navigationContext), null);
        GraphicFlyOver graphicFlyOver = new GraphicFlyOver(String.valueOf(LsBoxInfo.ModuleDescr[this.moduleType]) + " Switching Module");
        graphicImage.setFlyOver(graphicFlyOver);
        this.grContainer.add(graphicImage);
    }

    private void build10BaseT(int n) {
        int n2;
        int n3;
        Point point;
        int n4 = 22;
        switch (n) {
            case 1: {
                point = new Point(mezz1Location);
                point.translate(6, 177);
                n3 = 12;
                n2 = 1;
                break;
            }
            case 2: {
                point = new Point(mezz2Location);
                point.translate(6, 177);
                n3 = 12;
                n2 = 13;
                break;
            }
            case 3: {
                point = new Point(mezz2Location);
                point.translate(18, 266);
                n3 = 4;
                n2 = 13;
                break;
            }
            default: {
                if (this.loggingOn) {
                    System.out.println("LS:buildBaseT - bad input type " + n);
                }
                return;
            }
        }
        this.lsPortMau_model = this.boxInfo.getLsModel("LsBaseTPortMau");
        this.addPorts(point, this.Slot, n2, n3, "RJ45.gif", n4, new NavigationDestination("ibm.nways.lspeed.LsPortEthernetPanel", this.lsPort_model));
    }

    private void buildLan() {
        int n = 27;
        Point point = new Point(118, 267);
        int n2 = 8;
        int n3 = 17;
        this.lsPortMau_model = this.boxInfo.getLsModel("LsBaseTPortMau");
        this.addPorts(point, this.Slot, n3, n2, "lan.gif", n, new NavigationDestination("ibm.nways.lspeed.LsPortEthernetPanel", this.lsPort_model));
    }

    private void build10BaseF(int n) {
        int n2;
        Point point;
        int n3 = 43;
        switch (n) {
            case 1: {
                point = new Point(mezz1Location);
                n2 = 1;
                break;
            }
            case 2: {
                point = new Point(mezz2Location);
                n2 = 11;
                break;
            }
            default: {
                if (this.isApplication) {
                    this.loggingOn = Log.getLog().getLoggingState();
                }
                if (this.loggingOn) {
                    System.out.println("LS:buildBaseF - bad input type " + n);
                }
                return;
            }
        }
        point.translate(11, 146);
        int n4 = 10;
        this.lsPortMau_model = this.boxInfo.getLsModel("LsFBFLPortMau");
        this.addPorts(point, this.Slot, n2, n4, "st.gif", n3, new NavigationDestination("ibm.nways.lspeed.LsPortEthernetPanel", this.lsPort_model));
    }

    private void buildFDDI(int n, int n2) {
        int n3 = 50;
        this.lsPortMau_model = this.boxInfo.getLsModel("LsFDDIPortMau");
        switch (n) {
            case 1: {
                Point point = new Point(mezz1Location);
                point.translate(14, 134);
                int n4 = 1;
                this.addFddiPortMaus(point, this.Slot, n4, n3, new NavigationDestination("ibm.nways.lspeed.LsPortfddiPanel", this.lsPort_model));
                point.translate(0, 160);
                n4 = 2;
                this.addFddiPortMaus(point, this.Slot, n4, n3, new NavigationDestination("ibm.nways.lspeed.LsPortfddiPanel", this.lsPort_model));
                return;
            }
            case 2: {
                Point point = new Point(mezz2Location);
                point.translate(10, 287);
                int n5 = n2;
                this.addFddiPortMaus(point, this.Slot, n5, n3, new NavigationDestination("ibm.nways.lspeed.LsPortfddiPanel", this.lsPort_model));
                return;
            }
        }
        if (this.isApplication) {
            this.loggingOn = Log.getLog().getLoggingState();
        }
        if (this.loggingOn) {
            System.out.println("LS:buildBaseF - bad input type " + n);
        }
    }

    private void buildBaseFX() {
        int n = 88;
        Point point = new Point(mezz1Location);
        point.translate(11, 155);
        int n2 = 4;
        int n3 = 1;
        this.lsPortMau_model = this.boxInfo.getLsModel("LscBaseTPortMau");
        this.addPorts(point, this.Slot, n3, n2, "sc.gif", n, new NavigationDestination("ibm.nways.lspeed.LsPortEthernetPanel", this.lsPort_model));
    }

    private void buildBaseTX() {
        int n = 78;
        Point point = new Point(mezz1Location);
        point.translate(8, 169);
        int n2 = 4;
        int n3 = 1;
        this.lsPortMau_model = this.boxInfo.getLsModel("LscBaseTPortMau");
        this.addPorts(point, this.Slot, n3, n2, "RJ45.gif", n, new NavigationDestination("ibm.nways.lspeed.LsPortEthernetPanel", this.lsPort_model));
    }

    private void buildTelco() {
        int n = 13;
        Label label = new Label("Logical Ports");
        label.setLocation(new Point(49, 260));
        this.grContainer.add(label);
        Point point = new Point(60, 300);
        int n2 = 12;
        int n3 = 1;
        this.lsPortMau_model = this.boxInfo.getLsModel("LsBaseTPortMau");
        this.addPorts(point, this.Slot, n3, n2, "logicalPort.gif", n, new NavigationDestination("ibm.nways.lspeed.LsPortEthernetPanel", this.lsPort_model));
        point = new Point(60, 470);
        n2 = 12;
        n3 = 13;
        this.addPorts(point, this.Slot, n3, n2, "logicalPort.gif", n, new NavigationDestination("ibm.nways.lspeed.LsPortEthernetPanel", this.lsPort_model));
    }

    private boolean buildAtm() {
        int n;
        Point point;
        boolean bl = true;
        int n2 = 0;
        new ModelInfo();
        this.lsOC3StatusPort_model = this.boxInfo.getLsModel("LsOC3StatusPort");
        if (this.lsOC3StatusPort_model != null) {
            point = new Point(mezz1Location);
            point.translate(26, 187);
            n = 162;
            this.createOC3Images(point, n);
        } else {
            bl = false;
            if (this.loggingOn) {
                System.out.println("LS: Error No OC3 adapters drawn - missing OC3Status model");
            }
        }
        n2 = this.boxInfo.getNumOfLecPorts(this.Slot);
        if (n2 == 0) {
            if (this.loggingOn) {
                System.out.println("LS:buildAtm missing number of bridge ports");
            }
            bl = false;
        } else {
            Label label = new Label("Defined");
            label.setLocation(new Point(140, 20));
            this.grContainer.add(label);
            label = new Label("BridgePorts-LECs");
            label.setLocation(new Point(130, 40));
            this.grContainer.add(label);
            n = 15;
            point = new Point(130, 80);
            int n3 = 1;
            this.lsPortMau_model = null;
            this.addPorts(point, this.Slot, n3, n2 < 32 ? n2 : 32, "logicalPort.gif", n, new NavigationDestination("ibm.nways.lspeed.LsPortLecPanel", this.lsPort_model));
            if (n2 > 32) {
                point.translate(65, 0);
                n3 = 33;
                this.addPorts(point, this.Slot, n3, n2 -= 32, "logicalPort.gif", n, new NavigationDestination("ibm.nways.lspeed.LsPortLecPanel", this.lsPort_model));
            }
        }
        return bl;
    }

    private void addPorts(Point point, Integer n, int n2, int n3, String string, int n4, NavigationDestination navigationDestination) {
        Font font = new Font("Serif", 1, 10);
        Image image = this.lsBrowser.imageFrom(this, string);
        Point point2 = new Point(point);
        navigationDestination.setGraphicPanelProducer(this);
        int n5 = 0;
        while (n5 < n3) {
            Integer n6 = new Integer(n2 + n5);
            ModelInfo modelInfo = new ModelInfo();
            modelInfo.add("Index.Slot", n);
            modelInfo.add("Index.Port", n6);
            NavigationContext navigationContext = new NavigationContext();
            NavInitialRow.setInitialRow(navigationContext, modelInfo);
            navigationContext.setParent(this.lsBrowser.getNavigationTree().getNavContext());
            Status status = this.getCompoundPortStatus(modelInfo, new Integer(1));
            GraphicImage graphicImage = new GraphicImage(image, point2, 2, new GraphicActionNavigate(this.lsBrowser, navigationDestination, navigationContext), status);
            GraphicFlyOver graphicFlyOver = new GraphicFlyOver("Port " + n6.toString());
            graphicImage.setFlyOver(graphicFlyOver);
            this.grContainer.add(graphicImage);
            if (string.equals("logicalPort.gif")) {
                Label label = new Label(n6.toString());
                label.setFont(font);
                Point point3 = new Point(point2);
                point3.translate(40, -7);
                label.setLocation(point3);
                this.grContainer.add(label);
            }
            point2.translate(0, n4);
            ++n5;
        }
    }

    private void addFddiPortMaus(Point point, Integer n, int n2, int n3, NavigationDestination navigationDestination) {
        Point point2 = new Point(point);
        Integer n4 = new Integer(n2);
        navigationDestination.setGraphicPanelProducer(this);
        int n5 = 1;
        while (n5 < 3) {
            ModelInfo modelInfo = new ModelInfo();
            modelInfo.add("Index.Slot", n);
            modelInfo.add("Index.Port", n4);
            NavigationContext navigationContext = new NavigationContext();
            NavInitialRow.setInitialRow(navigationContext, modelInfo);
            navigationContext.setParent(this.lsBrowser.getNavigationTree().getNavContext());
            Status status = this.getCompoundPortStatus(modelInfo, new Integer(n5));
            GraphicImage graphicImage = new GraphicImage(this.lsBrowser.imageFrom(this, "fddi.gif"), point2, 2, new GraphicActionNavigate(this.lsBrowser, navigationDestination, navigationContext), status);
            GraphicFlyOver graphicFlyOver = n5 == 1 ? new GraphicFlyOver("Port " + n4.toString() + "A") : new GraphicFlyOver("Port " + n4.toString() + "B");
            graphicImage.setFlyOver(graphicFlyOver);
            this.grContainer.add(graphicImage);
            point2.translate(0, n3);
            ++n5;
        }
    }

    private Status getCompoundPortStatus(ModelInfo modelInfo, Integer n) {
        CompoundStatus compoundStatus = null;
        StatusProxy statusProxy = null;
        try {
            RemoteStatus remoteStatus = this.lsPort_model.getStatusRefForRow(modelInfo);
            StatusProxy statusProxy2 = new StatusProxy(remoteStatus);
            RemoteStatus remoteStatus2 = this.lsPortStatus2_model.getStatusRefForRow(modelInfo);
            StatusProxy statusProxy3 = new StatusProxy(remoteStatus2);
            if (this.lsPortMau_model != null) {
                modelInfo.add("Index.Mau", n);
                RemoteStatus remoteStatus3 = this.lsPortMau_model.getStatusRefForRow(modelInfo);
                statusProxy = new StatusProxy(remoteStatus3);
            }
            compoundStatus = new CompoundStatus();
            compoundStatus.setName(new I18NStringTranslated(lspeedBundle.getString("PortCompoundStatus")));
            compoundStatus.setManager(new LsPortCompStatusMgr());
            compoundStatus.addDependent(statusProxy2);
            compoundStatus.addDependent(statusProxy3);
            if (statusProxy != null) {
                compoundStatus.addDependent(statusProxy);
            }
        }
        catch (Exception exception) {
            if (this.loggingOn) {
                exception.printStackTrace();
            }
            compoundStatus = null;
        }
        return compoundStatus;
    }

    private void createOC3Images(Point point, int n) {
        NavigationDestination navigationDestination = new NavigationDestination("ibm.nways.lspeed.LsPortLecPanel", this.lsPort_model);
        navigationDestination.setGraphicPanelProducer(this);
        ModelInfo modelInfo = new ModelInfo();
        modelInfo.add("Index.Slot", this.Slot);
        modelInfo.add("Index.Port", new Integer(1));
        NavigationContext navigationContext = new NavigationContext();
        NavInitialRow.setInitialRow(navigationContext, modelInfo);
        navigationContext.setParent(this.lsBrowser.getNavigationTree().getNavContext());
        ModelInfo modelInfo2 = new ModelInfo();
        modelInfo2.add("Index.Slot", this.Slot);
        modelInfo2.add("Index.Subslot", new Integer(1));
        int n2 = 1;
        while (n2 <= 2) {
            StatusProxy statusProxy;
            modelInfo2.add("Index.Port", new Integer(n2));
            if (n2 == 2) {
                try {
                    ModelInfo modelInfo3 = this.lsOC3StatusPort_model.getInfo("OC3PortInfo", "default", modelInfo2);
                    Serializable serializable = modelInfo3.get("OC3PortInfo.OperStatus");
                    if (!(serializable instanceof Integer)) break;
                    if ((Integer)serializable == 51) {
                        return;
                    }
                }
                catch (Exception exception) {
                    return;
                }
            }
            try {
                statusProxy = null;
                RemoteStatus remoteStatus = this.lsOC3StatusPort_model.getStatusRefForRow(modelInfo2);
                if (remoteStatus != null) {
                    statusProxy = new StatusProxy(remoteStatus);
                }
            }
            catch (Exception exception) {
                if (this.loggingOn && n2 == 1) {
                    System.out.println("LS: Error getting status - proxy");
                    exception.printStackTrace();
                }
                statusProxy = null;
            }
            GraphicImage graphicImage = new GraphicImage(this.lsBrowser.imageFrom(this, "oc3.gif"), point, 2, new GraphicActionNavigate(this.lsBrowser, navigationDestination, navigationContext), statusProxy);
            GraphicFlyOver graphicFlyOver = new GraphicFlyOver("OC3 Adapter " + n2);
            graphicImage.setFlyOver(graphicFlyOver);
            this.grContainer.add(graphicImage);
            point.translate(0, n);
            ++n2;
        }
    }

    private GraphicPanel ConfigChangeWarningPanel(Integer n) {
        Font font = new Font("Serif", 1, 14);
        Object[] objectArray = new Object[]{n};
        this.grContainer = new GraphicContainer();
        I18NMsgFormat i18NMsgFormat = new I18NMsgFormat("ibm.nways.lspeed.LsGeneralResources", "ConfigChangeWarning", objectArray);
        MultiLineLabel multiLineLabel = new MultiLineLabel(i18NMsgFormat.getTranslation(), 0);
        multiLineLabel.setFont(font);
        multiLineLabel.setLocation(new Point(5, 40));
        this.grContainer.add(multiLineLabel);
        this.graphicPanel = new GraphicPanel(this.lsBrowser, this.grContainer);
        return this.graphicPanel;
    }

    static {
        helpPt = new Point(0, 0);
        mezz1Location = new Point(0, 75);
        mezz2Location = new Point(39, 75);
    }
}

